(function(){
  const cfg = window.__FIREBASE_CONFIG__;
  const app = firebase.initializeApp(cfg || {});
  const auth = firebase.auth();
  const db = firebase.firestore();
  if (db && db.enablePersistence) { db.enablePersistence({synchronizeTabs:true}).catch(()=>{}); }

  const loginBtn = document.getElementById('loginBtn');
  const loginBtnMain = document.getElementById('loginBtnMain');
  const logoutBtn = document.getElementById('logoutBtn');
  const userPhoto = document.getElementById('userPhoto');
  const userName = document.getElementById('userName');
  const authGate = document.getElementById('authGate');
  const appShell = document.getElementById('appShell');
  const userChip = document.getElementById('userChip');

  function showGate(){ authGate.classList.remove('hidden'); appShell.classList.add('hidden'); loginBtn.classList.remove('hidden'); userChip.classList.add('hidden'); }
  function showApp(user){ authGate.classList.add('hidden'); appShell.classList.remove('hidden'); loginBtn.classList.add('hidden'); userChip.classList.remove('hidden'); userPhoto.src=user.photoURL||''; userName.textContent=user.displayName||user.email||'Account'; }
  function signIn(){ const provider = new firebase.auth.GoogleAuthProvider(); auth.signInWithPopup(provider); }
  function signOut(){ auth.signOut(); }
  loginBtn.onclick = signIn; loginBtnMain.onclick = signIn; logoutBtn.onclick = signOut;

  const DB_KEY = "fgj.tw.v2.localcache";
  let unsub=null, saveTimer=null, sheetTimer=null;
  function readLocal(){ try { return JSON.parse(localStorage.getItem(DB_KEY))||null; } catch { return null; } }
  function writeLocal(obj){ localStorage.setItem(DB_KEY, JSON.stringify(obj)); }
  function clearLocal(){ localStorage.removeItem(DB_KEY); }

  function pushSheet(state){
    const url = window.__SHEET_WEBHOOK__; const token = window.__SHEET_SECRET__;
    if (!url || !token) return;
    fetch(url, { method:'POST', headers:{'Content-Type':'application/json'}, body: JSON.stringify({ token, state }) }).catch(()=>{});
  }
  function bumpSheet(state){ if (sheetTimer) clearTimeout(sheetTimer); sheetTimer = setTimeout(()=> pushSheet(state), 1500); }

  window.__sync__ = {
    saveSoon(nextState){
      writeLocal(nextState);
      if (saveTimer) clearTimeout(saveTimer);
      saveTimer = setTimeout(async ()=>{
        const user=auth.currentUser; if(!user) return;
        await db.collection('users').doc(user.uid).collection('appState').doc('state').set(nextState, { merge:false });
        bumpSheet(nextState);
      }, 600);
    },
    clearLocal, readLocal
  };

  auth.onAuthStateChanged(async (user)=>{
    if (!user){ showGate(); if (unsub) unsub(); return; }
    showApp(user);
    const docRef = db.collection('users').doc(user.uid).collection('appState').doc('state');
    const snap = await docRef.get({ source:'server' }).catch(()=>null);
    let state = snap && snap.exists ? snap.data() : readLocal();
    if (!state){ state = { v:2, entries:[], journals:[], goals:[] }; }

    if (window.__app__ && window.__app__.hydrate){ window.__app__.hydrate(state); }
    writeLocal(state);
    bumpSheet(state);

    if (unsub) unsub();
    unsub = docRef.onSnapshot((doc)=>{
      if (!doc.exists) return;
      const cloud = doc.data();
      if (window.__app__ && window.__app__.hydrate){ window.__app__.hydrate(cloud); writeLocal(cloud); bumpSheet(cloud); }
    });
  });
})();