/** Google Sheets Webhook for Gym Journal (Apps Script) */
const SECRET = 'CHANGE_THIS_TO_A_RANDOM_STRING'; // set to '' to disable
function doOptions(){ return ContentService.createTextOutput('').setMimeType(ContentService.MimeType.TEXT).setHeader('Access-Control-Allow-Origin','*').setHeader('Access-Control-Allow-Methods','POST, OPTIONS').setHeader('Access-Control-Allow-Headers','Content-Type, Authorization'); }
function doPost(e){
  try{
    if (e.parameter && e.parameter.method==='options') return doOptions();
    const body = e.postData && e.postData.contents ? JSON.parse(e.postData.contents) : {};
    const token = (body && body.token) || (e.parameter && e.parameter.token) || (e.parameter && e.parameter.Authorization) || '';
    if (SECRET && token !== SECRET) return respond(401, {ok:false, error:'unauthorized'});
    const state = body.state || {};
    const ss = SpreadsheetApp.getActiveSpreadsheet();
    const sE = getSheet(ss,'Entries'), sJ=getSheet(ss,'Journals'), sG=getSheet(ss,'Goals');
    writeEntries(sE, state.entries||[]); writeJournals(sJ, state.journals||[]); writeGoals(sG, state.goals||[]);
    return respond(200, {ok:true});
  }catch(err){ return respond(500, {ok:false, error:String(err)}); }
}
function getSheet(ss,name){ return ss.getSheetByName(name) || ss.insertSheet(name); }
function writeEntries(s, entries){
  const rows=[];
  entries.forEach(e=>{
    if (e.sets && e.sets.length){
      e.sets.forEach(s1=> rows.push([e.id||'',e.date||'',e.exercise||'',s1.w||s1.weight||'',s1.r||s1.reps||'',s1.rpe||'',e.note||'',e.createdAt||'']));
    } else {
      rows.push([e.id||'',e.date||'',e.exercise||'','','','',e.note||'',e.createdAt||'']);
    }
  });
  s.clearContents(); const h=['id','date','exercise','weight','reps','rpe','note','createdAt'];
  s.getRange(1,1,1,h.length).setValues([h]); if (rows.length) s.getRange(2,1,rows.length,h.length).setValues(rows);
}
function writeJournals(s, js){ s.clearContents(); const h=['id','date','text','createdAt']; s.getRange(1,1,1,h.length).setValues([h]); if(!js.length) return; const rows=js.map(j=>[j.id||'',j.date||'',j.text||'',j.createdAt||'']); s.getRange(2,1,rows.length,h.length).setValues(rows); }
function writeGoals(s, gs){ s.clearContents(); const h=['id','exercise','target','notes','createdAt']; s.getRange(1,1,1,h.length).setValues([h]); if(!gs.length) return; const rows=gs.map(g=>[g.id||'',g.exercise||'',g.target||'',g.notes||'',g.createdAt||'']); s.getRange(2,1,rows.length,h.length).setValues(rows); }
function respond(code,obj){ const out=ContentService.createTextOutput(JSON.stringify(obj)).setMimeType(ContentService.MimeType.JSON); out.setHeader('Access-Control-Allow-Origin','*').setHeader('Access-Control-Allow-Methods','POST, OPTIONS').setHeader('Access-Control-Allow-Headers','Content-Type, Authorization'); return out; }
