const $ = (q) => document.querySelector(q);
const $$ = (q) => Array.from(document.querySelectorAll(q));
const views = {
  today: document.getElementById('view-today'),
  history: document.getElementById('view-history'),
  progress: document.getElementById('view-progress'),
  journal: document.getElementById('view-journal'),
  settings: document.getElementById('view-settings'),
};
function setActiveTab(name){
  $$("#tabs .tab").forEach(b=>{ const a=b.dataset.tab===name; b.classList.toggle("bg-accent",a); b.classList.toggle("text-base",a); b.classList.toggle("text-dim",!a); });
  $$(".navbtn").forEach(b=>{ const a=b.dataset.tab===name; b.classList.toggle("text-ink",a); b.classList.toggle("text-dim",!a); });
  Object.entries(views).forEach(([k,el])=> el.classList.toggle("hidden", k!==name));
  if (name==='progress') drawChart();
}
$$("#tabs .tab").forEach(b=> b.addEventListener('click', ()=> setActiveTab(b.dataset.tab)));
$$(".navbtn").forEach(b=> b.addEventListener('click', ()=> setActiveTab(b.dataset.tab)));
function todayISO(){ const d=new Date(); d.setMinutes(d.getMinutes()-d.getTimezoneOffset()); return d.toISOString().slice(0,10); }
function uid(){ return Math.random().toString(36).slice(2,9); }
let state = { v:2, entries:[], journals:[], goals:[] };
// TODAY
const exerciseEl = document.getElementById('exercise');
const wEl = document.getElementById('w');
const rEl = document.getElementById('r');
const rpEl = document.getElementById('rp');
const addSetBtn = document.getElementById('addSetBtn');
const notesEl = document.getElementById('notes');
const setsList = document.getElementById('setsList');
const volumePill = document.getElementById('volumePill');
const bestPill = document.getElementById('bestPill');
const finishSessionBtn = document.getElementById('finishSessionBtn');
const recentChips = document.getElementById('recentChips');
function renderRecentChips(){
  const names = Array.from(new Set(state.entries.slice(-30).map(e=>e.exercise))).slice(-8).reverse();
  recentChips.innerHTML = names.map(n=>`<button class="px-3 py-1 rounded-full border border-line text-dim hover:text-ink" data-name="${n}">${n}</button>`).join('');
  recentChips.querySelectorAll('button').forEach(b=> b.addEventListener('click', ()=>{ exerciseEl.value=b.dataset.name; exerciseEl.focus(); }));
}
function currentSetsFor(exName){ return state.entries.filter(e=> e.exercise.toLowerCase()===exName.toLowerCase()).flatMap(e=> e.sets||[]); }
function updateSessionMeta(){
  const ex=(exerciseEl.value||"").trim(); if(!ex){ volumePill.textContent="Volume: 0"; bestPill.classList.add('hidden'); return; }
  const sets=currentSetsFor(ex); const vol=sets.reduce((v,s)=> v+(s.w||0)*(s.r||0),0); const best=sets.reduce((m,s)=> Math.max(m,s.w||0),0);
  volumePill.textContent=`Volume: ${Math.round(vol)}`;
  if(best>0){ bestPill.textContent=`Best: ${best}`; bestPill.classList.remove('hidden'); } else { bestPill.classList.add('hidden'); }
}
function renderSetsList(){
  const ex=(exerciseEl.value||"").trim(); 
  const entries=state.entries.filter(e=> e.exercise.toLowerCase()===ex.toLowerCase());
  const rows=[]; entries.forEach(e=>{ (e.sets||[]).forEach((s,i)=>{
    rows.push(`<div class="flex items-center justify-between border border-line rounded-xl px-3 py-2">
      <div class="text-sm">${e.date} • <span class="font-semibold">${s.w||0} × ${s.r||0}</span> @${s.rpe||''}</div>
      <button class="text-dim border border-line rounded-lg px-2 py-1" data-e="${e.id}" data-i="${i}">Delete</button>
    </div>`);
  }); });
  setsList.innerHTML = rows.join('') || `<div class="text-dim text-sm">No sets yet.</div>`;
  setsList.querySelectorAll('button[data-e]').forEach(btn=> btn.addEventListener('click', ()=>{
    const eid=btn.getAttribute('data-e'); const idx=Number(btn.getAttribute('data-i'));
    const ent=state.entries.find(x=>x.id===eid); if(!ent) return;
    ent.sets.splice(idx,1); if(!ent.sets.length){ state.entries=state.entries.filter(x=>x.id!==eid); }
    window.__sync__.saveSoon(state); renderSetsList(); updateSessionMeta(); renderRecentChips();
  }));
}
addSetBtn.addEventListener('click', ()=>{
  const ex=(exerciseEl.value||"").trim(); if(!ex) return alert("Add an exercise name.");
  const w=Number(wEl.value||0), r=Number(rEl.value||0), rp=Number(rpEl.value||0); if(!w||!r) return alert("Add weight and reps.");
  const today=todayISO(); let entry=state.entries.find(e=> e.date===today && e.exercise.toLowerCase()===ex.toLowerCase());
  if(!entry){ entry={ id:uid(), date:today, exercise:ex, sets:[], note:"", createdAt:Date.now() }; state.entries.push(entry); }
  entry.sets.push({ w, r, rpe: rp||undefined }); entry.note=(notesEl.value||"").trim(); window.__sync__.saveSoon(state);
  wEl.focus(); wEl.select(); renderSetsList(); updateSessionMeta(); renderRecentChips();
});
finishSessionBtn.addEventListener('click', ()=>{ exerciseEl.value=""; wEl.value=""; rEl.value=""; rpEl.value=""; notesEl.value=""; renderSetsList(); updateSessionMeta(); });
// HISTORY
const historyList=document.getElementById('historyList'); const historySearch=document.getElementById('historySearch');
function renderHistory(){
  const q=(historySearch.value||"").toLowerCase();
  const items=[...state.entries].sort((a,b)=> new Date(b.date)-new Date(a.date)).filter(e=> !q || e.exercise.toLowerCase().includes(q));
  historyList.innerHTML = items.map(e=>{
    const vol=e.sets.reduce((v,s)=> v+(s.w||0)*(s.r||0),0); const best=e.sets.reduce((m,s)=> Math.max(m,s.w||0),0);
    return `<div class="border border-line rounded-xl p-3 bg-base">
      <div class="flex items-center justify-between"><div class="font-semibold">${e.exercise}</div><div class="text-dim text-sm">${e.date}</div></div>
      <div class="text-dim text-sm mt-1">Best ${best} • Vol ${Math.round(vol)} • Sets ${e.sets.length}</div>
      ${e.note?`<div class="text-dim mt-1">${e.note}</div>`:""}
    </div>`;
  }).join('') || `<div class="text-dim text-sm">No history yet.</div>`;
}
historySearch.addEventListener('input', renderHistory);
// JOURNAL
const jDate=document.getElementById('jDate'); const jText=document.getElementById('jText'); const saveJournalBtn=document.getElementById('saveJournalBtn'); const journalSavedMsg=document.getElementById('journalSavedMsg'); const journalsEl=document.getElementById('journals');
saveJournalBtn.addEventListener('click', ()=>{
  const date=jDate.value||todayISO(); const text=(jText.value||"").trim(); if(!text) return alert("Write something first.");
  state.journals.push({ id:uid(), date, text, createdAt:Date.now() }); window.__sync__.saveSoon(state); jText.value=""; journalSavedMsg.classList.remove('hidden'); setTimeout(()=>journalSavedMsg.classList.add('hidden'),1200); renderJournals();
});
function renderJournals(){
  const list=[...state.journals].sort((a,b)=> b.createdAt-a.createdAt).slice(0,50);
  journalsEl.innerHTML = list.map(n=>`
    <div class="border border-line rounded-xl p-3 bg-base">
      <div class="flex items-center justify-between gap-3"><strong>${n.date}</strong><button class="px-2 py-1 rounded-lg border border-line text-dim" data-id="${n.id}">Delete</button></div>
      <div class="text-dim whitespace-pre-wrap mt-1">${n.text}</div>
    </div>`).join('') || `<div class="text-dim text-sm">No notes yet.</div>`;
  journalsEl.querySelectorAll('button[data-id]').forEach(b=> b.addEventListener('click', ()=>{ state.journals=state.journals.filter(x=> x.id!==b.dataset.id); window.__sync__.saveSoon(state); renderJournals(); }));
}
// PROGRESS
const pExercise=document.getElementById('pExercise'); const pMetric=document.getElementById('pMetric'); const chart=document.getElementById('chart'); const ctx=chart.getContext('2d');
pExercise.addEventListener('input', drawChart); pMetric.addEventListener('change', drawChart);
function dataForExercise(name){
  const relevant=state.entries.filter(e=> e.exercise.toLowerCase()===name.toLowerCase()).sort((a,b)=> new Date(a.date)-new Date(b.date));
  return relevant.slice(-40).map(e=>{ const bestW=e.sets.reduce((m,s)=> Math.max(m,s.w||0),0); const bestR=e.sets.reduce((m,s)=> Math.max(m,s.r||0),0); const vol=e.sets.reduce((v,s)=> v+(s.w||0)*(s.r||0),0); return {date:e.date, best_weight:bestW, best_reps:bestR, best_volume:Math.round(vol)}; });
}
function drawChart(){
  const name=(pExercise.value||"").trim(); ctx.clearRect(0,0,chart.width,chart.height); if(!name) return;
  const pts=dataForExercise(name); if(!pts.length) return; const metric=pMetric.value; const values=pts.map(p=>p[metric]);
  const padY=12, padX=36, w=chart.width, h=chart.height; const minV=Math.min(...values), maxV=Math.max(...values);
  const y=(v)=> maxV===minV? h/2 : h - padY - ((v-minV)/(maxV-minV))*(h-2*padY); const x=(i)=> padX + i*((w-2*padX)/((values.length-1)||1));
  ctx.globalAlpha=.35; ctx.strokeStyle="#1a2440"; ctx.beginPath(); [0,0.25,0.5,0.75,1].forEach(f=>{ const yy=padY+f*(h-2*padY); ctx.moveTo(padX,yy); ctx.lineTo(w-padX,yy); }); ctx.stroke(); ctx.globalAlpha=1;
  ctx.beginPath(); ctx.lineWidth=2; ctx.strokeStyle="#60a5fa"; values.forEach((v,i)=>{ const xi=x(i), yi=y(v); i?ctx.lineTo(xi,yi):ctx.moveTo(xi,yi); }); ctx.stroke();
  ctx.fillStyle="#34d399"; values.forEach((v,i)=>{ const xi=x(i), yi=y(v); ctx.beginPath(); ctx.arc(xi,yi,3,0,Math.PI*2); ctx.fill(); });
  const last=values[values.length-1]; ctx.fillStyle="#9fb0c9"; ctx.font="12px system-ui"; ctx.fillText(String(last), w-padX+6, y(last)+4);
  const delta=values.length>1?(last-values[0]):0; document.getElementById('progressInsights').textContent=`${metric.replace('_',' ')}: ${values[0]} → ${last} (${delta>=0?'+':''}${delta}) over ${values.length} sessions.`;
}
// Export/Import/Cache
document.getElementById('exportBtn').addEventListener('click', ()=>{ const blob=new Blob([JSON.stringify(state,null,2)], {type:'application/json'}); const url=URL.createObjectURL(blob); const a=document.createElement('a'); a.href=url; a.download='gym-journal.json'; document.body.appendChild(a); a.click(); a.remove(); URL.revokeObjectURL(url); });
document.getElementById('importInput').addEventListener('change', async (e)=>{ const file=e.target.files[0]; if(!file) return; try{ const text=await file.text(); const data=JSON.parse(text); if(!('entries'in data && 'journals'in data && 'goals'in data)) throw new Error('Invalid file'); state=data; window.__sync__.saveSoon(state); hydrate(state); alert('Imported successfully.'); }catch(err){ alert('Import failed: '+err.message); } finally{ e.target.value=""; } });
document.getElementById('wipeBtn').addEventListener('click', ()=>{ if(!confirm('Erase local cache? (Cloud copy remains)')) return; window.__sync__.clearLocal(); alert('Local cache cleared.'); });
// Hydration
function hydrate(next){ if(!next) return; state=next; renderRecentChips(); renderSetsList(); updateSessionMeta(); renderHistory(); renderJournals(); setActiveTab('today'); }
window.__app__={ hydrate }; setActiveTab('today');